package options

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestOptions_MergePaginationOptions(t *testing.T) {

	var tt = []struct {
		name     string
		options  []PaginationOptions
		expected PaginationOptions
	}{
		{
			name:     "Nil option",
			options:  nil,
			expected: PaginationOptions{},
		},
		{
			name:     "Empty options",
			options:  []PaginationOptions{},
			expected: PaginationOptions{},
		},
		{
			name:     "One option",
			options:  []PaginationOptions{{PageNum: 10, PageSize: 100}},
			expected: PaginationOptions{PageNum: 10, PageSize: 100},
		},
		{
			name:     "Merge #1",
			options:  []PaginationOptions{{PageNum: 0, PageSize: 0}, {PageNum: 10, PageSize: 100}},
			expected: PaginationOptions{PageNum: 10, PageSize: 100},
		},
		{
			name:     "Merge #2",
			options:  []PaginationOptions{{PageNum: 10, PageSize: 100}, {PageNum: 0, PageSize: 0}},
			expected: PaginationOptions{PageNum: 10, PageSize: 100},
		},
		{
			name:     "Merge #3",
			options:  []PaginationOptions{{PageNum: 0, PageSize: 0}, {PageNum: 10, PageSize: 100}, {PageNum: 0, PageSize: 0}},
			expected: PaginationOptions{PageNum: 10, PageSize: 100},
		},
		{
			name:     "Merge #4",
			options:  []PaginationOptions{{PageNum: 10, PageSize: 100}, {}},
			expected: PaginationOptions{PageNum: 10, PageSize: 100},
		},
	}

	for _, v := range tt {

		t.Run(v.name, func(t *testing.T) {
			actual := MergePaginationOptions(v.options...)
			assert.Equal(t, v.expected, actual)
		})
	}
}
