package members

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Reset(ctx context.Context) error
	Init(ctx context.Context) error

	Set(ctx context.Context, orgID, userID string, role Role) (err error)
	Remove(ctx context.Context, filter *Filter) (total int, err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (memberships []*Member, err error)
}

type Filter struct {
	OrgID  string
	UserID string
	Role   Role
}
