package members

import (
	"context"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/members
// @grpc-addr account.members.Members
type Members interface {
	Set(ctx context.Context, orgId, userId string, role Role) (err error)

	Get(ctx context.Context, orgId, userId string) (role Role, err error)

	Remove(ctx context.Context, orgId, userId string) (err error)

	// @microgen -
	RemoveAll(ctx context.Context, orgId string) (err error)

	ListMembers(ctx context.Context, orgId string) (members []*Member, err error)

	ListOrganizations(ctx context.Context, userId string) (organizations []*Member, err error)
}
