package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/access_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/members -i Members -t ../../../assets/templates/middleware/access_log -o logging_middleware.go -l ""

import (
	"context"
	"fmt"
	"time"

	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/members"
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

// loggingMiddleware implements members.Members that is instrumented with logging
type loggingMiddleware struct {
	logger *zap.Logger
	next   members.Members
}

// LoggingMiddleware instruments an implementation of the members.Members with simple logging
func LoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next members.Members) members.Members {
		return &loggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *loggingMiddleware) Get(ctx context.Context, orgId string, userId string) (role members.Role, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"orgId":  orgId,
		"userId": userId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Get.Request", fields...)

	role, err = m.next.Get(ctx, orgId, userId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"role": role,
		"err":  err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Get.Response", fields...)

	return role, err
}

func (m *loggingMiddleware) ListMembers(ctx context.Context, orgId string) (members []*members.Member, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":   ctx,
		"orgId": orgId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListMembers.Request", fields...)

	members, err = m.next.ListMembers(ctx, orgId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"members": members,
		"err":     err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListMembers.Response", fields...)

	return members, err
}

func (m *loggingMiddleware) ListOrganizations(ctx context.Context, userId string) (organizations []*members.Member, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"userId": userId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListOrganizations.Request", fields...)

	organizations, err = m.next.ListOrganizations(ctx, userId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"organizations": organizations,
		"err":           err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListOrganizations.Response", fields...)

	return organizations, err
}

func (m *loggingMiddleware) Remove(ctx context.Context, orgId string, userId string) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"orgId":  orgId,
		"userId": userId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Remove.Request", fields...)

	err = m.next.Remove(ctx, orgId, userId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Remove.Response", fields...)

	return err
}

func (m *loggingMiddleware) RemoveAll(ctx context.Context, orgId string) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":   ctx,
		"orgId": orgId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("RemoveAll.Request", fields...)

	err = m.next.RemoveAll(ctx, orgId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("RemoveAll.Response", fields...)

	return err
}

func (m *loggingMiddleware) Set(ctx context.Context, orgId string, userId string, role members.Role) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"orgId":  orgId,
		"userId": userId,
		"role":   role} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Set.Request", fields...)

	err = m.next.Set(ctx, orgId, userId, role)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Set.Response", fields...)

	return err
}
