package members

import (
	"fmt"
)

type Member struct {
	OrgId  string `bson:"orgId"`
	UserId string `bson:"userId"`
	Role   Role   `bson:"role"`
}

type Role uint

const (
	NotMember Role = iota
	RoleMember
	RoleOwner
	RoleAdmin
)

func (r Role) IsPrivileged() bool {
	return r == RoleOwner || r == RoleAdmin
}

func (r Role) Format(s fmt.State, verb rune) {
	switch r {
	case RoleOwner:
		fmt.Fprint(s, "owner")
	case RoleAdmin:
		fmt.Fprint(s, "admin")
	case RoleMember:
		fmt.Fprint(s, "member")
	}
}
