package locales

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Reset(ctx context.Context, spaceID string) error

	Create(ctx context.Context, locale *Locale) (created *Locale, err error)
	Find(ctx context.Context, spaceID string, filter *Filter, opts *options.FindOptions) (locales []*Locale, total int, err error)
	Delete(ctx context.Context, spaceID string, filter *Filter) (total int, err error)
}

type Filter struct {
	ID   []string
	Name []string
}
