// Code generated by microgen 0.9.1. DO NOT EDIT.

package transport

import (
	"context"
	"strings"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	endpoint "github.com/go-kit/kit/endpoint"
	"github.com/hashicorp/go-multierror"
)

func Endpoints(svc items.Items) EndpointsSet {
	return EndpointsSet{
		AggregateEndpoint:          AggregateEndpoint(svc),
		AggregatePublishedEndpoint: AggregatePublishedEndpoint(svc),
		ArchiveEndpoint:            ArchiveEndpoint(svc),
		CreateEndpoint:             CreateEndpoint(svc),
		DeleteEndpoint:             DeleteEndpoint(svc),
		FindArchivedEndpoint:       FindArchivedEndpoint(svc),
		FindEndpoint:               FindEndpoint(svc),
		FindPublishedEndpoint:      FindPublishedEndpoint(svc),
		GetEndpoint:                GetEndpoint(svc),
		GetPublishedEndpoint:       GetPublishedEndpoint(svc),
		GetRevisionEndpoint:        GetRevisionEndpoint(svc),
		IntrospectEndpoint:         IntrospectEndpoint(svc),
		ListRevisionsEndpoint:      ListRevisionsEndpoint(svc),
		PublishEndpoint:            PublishEndpoint(svc),
		UnarchiveEndpoint:          UnarchiveEndpoint(svc),
		UndeleteEndpoint:           UndeleteEndpoint(svc),
		UnpublishEndpoint:          UnpublishEndpoint(svc),
		UpdateEndpoint:             UpdateEndpoint(svc),
	}
}

func CreateEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*CreateRequest)
		res0, res1 := svc.Create(arg0, req.Item, req.Opts...)
		return &CreateResponse{Created: res0}, res1
	}
}

func IntrospectEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*IntrospectRequest)
		res0, res1, res2 := svc.Introspect(arg0, req.Item, req.Opts...)
		resp := &IntrospectResponse{
			Item:   res0,
			Schema: res1,
		}
		if res2 != nil {

			err := res2

			var merr *multierror.Error
			if (strings.Contains(err.Error(), "validation error") ||
				strings.Contains(err.Error(), "modification error") ||
				strings.Contains(err.Error(), "decode error") ||
				strings.Contains(err.Error(), "encode error")) && errors.As(err, &merr) {

				errs := make([]error, 0)
				for _, e := range merr.WrappedErrors() {
					var errField errors.FieldError
					if errors.As(e, &errField) {
						errs = append(errs, e)
					}
				}

				if len(errs) > 0 {
					resp.ValidationErrors = errs
					res2 = nil
				}
			}
		}
		return resp, res2
	}
}

func GetEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*GetRequest)
		res0, res1 := svc.Get(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.ItemId, req.Options...)
		return &GetResponse{Item: res0}, res1
	}
}

func FindEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*FindRequest)
		res0, res1, res2 := svc.Find(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.Filter, req.Options...)
		return &FindResponse{
			Items: res0,
			Total: res1,
		}, res2
	}
}

func UpdateEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*UpdateRequest)
		res0 := svc.Update(arg0, req.Item, req.Options...)
		return &UpdateResponse{}, res0
	}
}

func DeleteEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*DeleteRequest)
		res0 := svc.Delete(arg0, req.Item, req.Options...)
		return &DeleteResponse{}, res0
	}
}

func UndeleteEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*UndeleteRequest)
		res0 := svc.Undelete(arg0, req.Item, req.Options...)
		return &UndeleteResponse{}, res0
	}
}

func PublishEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*PublishRequest)
		res0 := svc.Publish(arg0, req.Item, req.Options...)
		return &PublishResponse{}, res0
	}
}

func UnpublishEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*UnpublishRequest)
		res0 := svc.Unpublish(arg0, req.Item, req.Options...)
		return &UnpublishResponse{}, res0
	}
}

func GetPublishedEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*GetPublishedRequest)
		res0, res1 := svc.GetPublished(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.ItemId, req.Options...)
		return &GetPublishedResponse{Item: res0}, res1
	}
}

func FindPublishedEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*FindPublishedRequest)
		res0, res1, res2 := svc.FindPublished(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.Filter, req.Options...)
		return &FindPublishedResponse{
			Items: res0,
			Total: res1,
		}, res2
	}
}

func GetRevisionEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*GetRevisionRequest)
		res0, res1 := svc.GetRevision(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.ItemId, req.RevisionId, req.Options...)
		return &GetRevisionResponse{Item: res0}, res1
	}
}

func ListRevisionsEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*ListRevisionsRequest)
		res0, res1 := svc.ListRevisions(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.ItemId, req.Options...)
		return &ListRevisionsResponse{Items: res0}, res1
	}
}

func ArchiveEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*ArchiveRequest)
		res0 := svc.Archive(arg0, req.Item, req.Options...)
		return &ArchiveResponse{}, res0
	}
}

func FindArchivedEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*FindArchivedRequest)
		res0, res1, res2 := svc.FindArchived(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.Filter, req.Options...)
		return &FindArchivedResponse{
			Items: res0,
			Total: res1,
		}, res2
	}
}

func UnarchiveEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*UnarchiveRequest)
		res0 := svc.Unarchive(arg0, req.Item, req.Options...)
		return &UnarchiveResponse{}, res0
	}
}

func AggregateEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*AggregateRequest)
		res0, res1 := svc.Aggregate(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.Filter, req.Options...)
		return &AggregateResponse{Result: res0}, res1
	}
}

func AggregatePublishedEndpoint(svc items.Items) endpoint.Endpoint {
	return func(arg0 context.Context, request interface{}) (interface{}, error) {
		req := request.(*AggregatePublishedRequest)
		res0, res1 := svc.AggregatePublished(arg0, req.SpaceId, req.EnvId, req.CollectionId, req.Filter, req.Options...)
		return &AggregatePublishedResponse{Result: res0}, res1
	}
}
