// Code generated by microgen 0.9.1. DO NOT EDIT.

// It is better for you if you do not change functions names!
// This file will never be overwritten.
package transportgrpc

import (
	"fmt"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
	"git.perx.ru/perxis/perxis-go/pkg/filter"
	service "git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/options"
	"git.perx.ru/perxis/perxis-go/pkg/schema"
	pbcommon "git.perx.ru/perxis/perxis-go/proto/common"
	pb "git.perx.ru/perxis/perxis-go/proto/items"
	jsoniter "github.com/json-iterator/go"
	"google.golang.org/protobuf/types/known/structpb"
)

func MapStringInterfaceToProto(data map[string]interface{}) (*structpb.Struct, error) {
	if data == nil {
		return nil, nil
	}
	return structpb.NewStruct(data)
}

func ProtoToMapStringInterface(protoData *structpb.Struct) (map[string]interface{}, error) {
	if protoData == nil {
		return nil, nil
	}
	return protoData.AsMap(), nil
}

func MapStringMapStringInterfaceToProto(translations map[string]map[string]interface{}) (map[string]*structpb.Struct, error) {
	if translations == nil {
		return nil, nil
	}
	res := make(map[string]*structpb.Struct, len(translations))
	for k, v := range translations {
		res[k], _ = MapStringInterfaceToProto(v)
	}
	return res, nil
}

func PtrPermissionsToProto(permissions *service.Permissions) (*pb.Permissions, error) {
	if permissions == nil {
		return nil, nil
	}

	return &pb.Permissions{
			Edit:       permissions.Edit,
			Archive:    permissions.Archive,
			Publish:    permissions.Publish,
			SoftDelete: permissions.SoftDelete,
			HardDelete: permissions.HardDelete,
		},
		nil
}

func ProtoToPtrPermissions(protoPermissions *pb.Permissions) (*service.Permissions, error) {
	if protoPermissions == nil {
		return nil, nil
	}

	return &service.Permissions{
			Edit:       protoPermissions.Edit,
			Archive:    protoPermissions.Archive,
			Publish:    protoPermissions.Publish,
			SoftDelete: protoPermissions.SoftDelete,
			HardDelete: protoPermissions.HardDelete,
		},
		nil
}

func ProtoToMapStringMapStringInterface(protoTranslations map[string]*structpb.Struct) (map[string]map[string]interface{}, error) {
	if protoTranslations == nil {
		return nil, nil
	}
	res := make(map[string]map[string]interface{}, len(protoTranslations))
	for k, v := range protoTranslations {
		res[k], _ = ProtoToMapStringInterface(v)
	}
	return res, nil
}

func PtrItemToProto(item *service.Item) (*pb.Item, error) {
	return service.ItemToProto(item), nil
}

func ProtoToPtrItem(protoItem *pb.Item) (*service.Item, error) {
	return service.ItemFromProto(protoItem), nil
}

func PtrFilterToProto(filter *service.Filter) (*pb.Filter, error) {
	if filter == nil {
		return nil, nil
	}

	dt := make([]*pbcommon.Filter, 0, len(filter.Data))
	for _, f := range filter.Data {
		pf := &pbcommon.Filter{
			Op:    string(f.Op),
			Field: f.Field,
		}

		val, err := structpb.NewValue(f.Value)
		if err != nil {
			return nil, err
		}
		pf.Value = val
		dt = append(dt, pf)
	}

	return &pb.Filter{
		Id:   filter.ID,
		Data: dt,
		Q:    filter.Q,
	}, nil
}

func ProtoToPtrFilter(protoFilter *pb.Filter) (*service.Filter, error) {
	if protoFilter == nil {
		return nil, nil
	}

	dt := make([]*filter.Filter, 0, len(protoFilter.Data))
	for _, pf := range protoFilter.Data {

		f := &filter.Filter{
			Op:    filter.Op(pf.Op),
			Field: pf.Field,
			Value: pf.Value.AsInterface(),
		}

		dt = append(dt, f)
	}

	return &service.Filter{
		ID:   protoFilter.Id,
		Data: dt,
		Q:    protoFilter.Q,
	}, nil
}

func PtrServicesFindOptionsToProto(opts *options.FindOptions) (*pbcommon.FindOptions, error) {
	if opts == nil {
		return nil, nil
	}
	return &pbcommon.FindOptions{
		Sort:          opts.Sort,
		PageNum:       int32(opts.PageNum),
		PageSize:      int32(opts.PageSize),
		Fields:        opts.Fields,
		ExcludeFields: opts.ExcludeFields,
	}, nil
}

func ProtoToPtrServicesFindOptions(protoOpts *pbcommon.FindOptions) (*options.FindOptions, error) {
	if protoOpts == nil {
		return nil, nil
	}
	return &options.FindOptions{
		SortOptions: options.SortOptions{
			Sort: protoOpts.Sort,
		},
		PaginationOptions: options.PaginationOptions{
			PageNum:  int(protoOpts.PageNum),
			PageSize: int(protoOpts.PageSize),
		},
		FieldOptions: options.FieldOptions{
			Fields:        protoOpts.Fields,
			ExcludeFields: protoOpts.ExcludeFields,
		},
	}, nil
}

func ListPtrItemToProto(items []*service.Item) ([]*pb.Item, error) {
	protoItems := make([]*pb.Item, 0, len(items))
	for _, itm := range items {
		pi, err := PtrItemToProto(itm)
		if err != nil {
			return nil, err
		}
		protoItems = append(protoItems, pi)
	}
	return protoItems, nil
}

func ProtoToListPtrItem(protoItems []*pb.Item) ([]*service.Item, error) {
	items := make([]*service.Item, 0, len(protoItems))
	for _, itm := range protoItems {
		pi, err := ProtoToPtrItem(itm)
		if err != nil {
			return nil, err
		}
		items = append(items, pi)
	}
	return items, nil
}

func ProtoToCreateOptions(protoOptions *pb.CreateOptions) ([]*service.CreateOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*service.CreateOptions{
		{UpdateAttrs: protoOptions.UpdateAttrs},
	}, nil
}

func CreateOptionsToProto(options []*service.CreateOptions) (*pb.CreateOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeCreateOptions(options...)

	return &pb.CreateOptions{
		UpdateAttrs: opts.UpdateAttrs,
	}, nil
}

func ElPtrGetOptionsToProto() {
	panic("function not provided") // TODO: provide converter
}

func ProtoToElPtrGetOptions() {
	panic("function not provided") // TODO: provide converter
}

func ElPtrFindOptionsToProto(options []*service.FindOptions) (*pb.FindOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeFindOptions(options...)

	var err error

	fo := &pb.FindOptions{
		Deleted:   opts.Deleted,
		Regular:   opts.Regular,
		Hidden:    opts.Hidden,
		Templates: opts.Templates,
	}

	fo.Options, err = PtrServicesFindOptionsToProto(&opts.FindOptions)
	if err != nil {
		return nil, err
	}

	return fo, nil
}

func ProtoToElPtrFindOptions(protoOptions *pb.FindOptions) ([]*service.FindOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	var err error
	fo := &service.FindOptions{
		Deleted:   protoOptions.Deleted,
		Regular:   protoOptions.Regular,
		Hidden:    protoOptions.Hidden,
		Templates: protoOptions.Templates,
	}

	o, err := ProtoToPtrServicesFindOptions(protoOptions.Options)
	if err != nil {
		return nil, err
	}
	if o != nil {
		fo.FindOptions = *o
	}

	return []*service.FindOptions{fo}, nil
}

func ProtoToUpdateOptions(protoOptions *pb.UpdateOptions) ([]*service.UpdateOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*service.UpdateOptions{
		{UpdateAttrs: protoOptions.UpdateAttrs},
	}, nil
}

func UpdateOptionsToProto(options []*service.UpdateOptions) (*pb.UpdateOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeUpdateOptions(options...)

	return &pb.UpdateOptions{
		UpdateAttrs: opts.UpdateAttrs,
	}, nil
}

func ProtoToDeleteOptions(protoOptions *pb.DeleteOptions) ([]*service.DeleteOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*service.DeleteOptions{
		{
			UpdateAttrs: protoOptions.UpdateAttrs,
			Erase:       protoOptions.Erase,
		},
	}, nil
}

func DeleteOptionsToProto(options []*service.DeleteOptions) (*pb.DeleteOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeDeleteOptions(options...)

	return &pb.DeleteOptions{
		UpdateAttrs: opts.UpdateAttrs,
		Erase:       opts.Erase,
	}, nil
}

func ProtoToUndeleteOptions(protoOptions *pb.UndeleteOptions) ([]*service.UndeleteOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*service.UndeleteOptions{
		{
			UpdateAttrs: protoOptions.UpdateAttrs,
		},
	}, nil
}

func UndeleteOptionsToProto(options []*service.UndeleteOptions) (*pb.UndeleteOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeUndeleteOptions(options...)

	return &pb.UndeleteOptions{
		UpdateAttrs: opts.UpdateAttrs,
	}, nil
}

func ProtoToPublishOptions(protoOptions *pb.PublishOptions) ([]*service.PublishOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*service.PublishOptions{
		{UpdateAttrs: protoOptions.UpdateAttrs},
	}, nil
}

func PublishOptionsToProto(options []*service.PublishOptions) (*pb.PublishOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergePublishOptions(options...)

	return &pb.PublishOptions{
		UpdateAttrs: opts.UpdateAttrs,
	}, nil
}
func ProtoToUnpublishOptions(protoOptions *pb.UnpublishOptions) ([]*service.UnpublishOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*service.UnpublishOptions{
		{UpdateAttrs: protoOptions.UpdateAttrs},
	}, nil
}

func UnpublishOptionsToProto(options []*service.UnpublishOptions) (*pb.UnpublishOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeUnpublishOptions(options...)

	return &pb.UnpublishOptions{
		UpdateAttrs: opts.UpdateAttrs,
	}, nil
}

func ElPtrGetPublishedOptionsToProto(options []*service.GetPublishedOptions) (*pb.GetPublishedOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeGetPublishedOptions(options...)

	return &pb.GetPublishedOptions{LocaleId: opts.LocaleID}, nil
}

func ProtoToElPtrGetPublishedOptions(protoOptions *pb.GetPublishedOptions) ([]*service.GetPublishedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	return []*service.GetPublishedOptions{{LocaleID: protoOptions.LocaleId}}, nil
}

func ElPtrFindPublishedOptionsToProto(options []*service.FindPublishedOptions) (*pb.FindPublishedOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeFindPublishedOptions(options...)

	var err error

	fo := &pb.FindPublishedOptions{
		Regular:   opts.Regular,
		Hidden:    opts.Hidden,
		Templates: opts.Templates,
	}
	fo.Options, err = PtrServicesFindOptionsToProto(&opts.FindOptions)
	if err != nil {
		return nil, err
	}

	fo.LocaleId = opts.LocaleID

	return fo, nil
}

func ProtoToElPtrFindPublishedOptions(protoOptions *pb.FindPublishedOptions) ([]*service.FindPublishedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	var err error
	fo := &service.FindPublishedOptions{
		Regular:   protoOptions.Regular,
		Hidden:    protoOptions.Hidden,
		Templates: protoOptions.Templates,
	}

	o, err := ProtoToPtrServicesFindOptions(protoOptions.Options)
	if err != nil {
		return nil, err
	}
	if o != nil {
		fo.FindOptions = *o
	}

	fo.LocaleID = protoOptions.LocaleId

	return []*service.FindPublishedOptions{fo}, nil
}

func ElPtrGetRevisionOptionsToProto() {
	panic("function not provided") // TODO: provide converter
}

func ProtoToElPtrGetRevisionOptions() {
	panic("function not provided") // TODO: provide converter
}

func ElPtrListRevisionsOptionsToProto(options []*service.ListRevisionsOptions) (*pb.ListRevisionsOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeListRevisionsOptions(options...)

	var err error

	fo := &pb.ListRevisionsOptions{}

	fo.Options, err = PtrServicesFindOptionsToProto(&opts.FindOptions)
	if err != nil {
		return nil, err
	}

	return fo, nil
}

func ProtoToElPtrListRevisionsOptions(protoOptions *pb.ListRevisionsOptions) ([]*service.ListRevisionsOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	var err error
	fo := &service.ListRevisionsOptions{}

	o, err := ProtoToPtrServicesFindOptions(protoOptions.Options)
	if err != nil {
		return nil, err
	}
	if o != nil {
		fo.FindOptions = *o
	}

	return []*service.ListRevisionsOptions{fo}, nil
}

func ElPtrArchiveOptionsToProto() {
	panic("function not provided") // TODO: provide converter
}

func ProtoToElPtrArchiveOptions() {
	panic("function not provided") // TODO: provide converter
}

func ElPtrFindArchivedOptionsToProto(options []*service.FindArchivedOptions) (*pb.FindArchivedOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := service.MergeFindArchivedOptions(options...)

	var err error

	fo := &pb.FindArchivedOptions{}

	fo.Options, err = PtrServicesFindOptionsToProto(&opts.FindOptions)
	if err != nil {
		return nil, err
	}

	return fo, nil
}

func ProtoToElPtrFindArchivedOptions(protoOptions *pb.FindArchivedOptions) ([]*service.FindArchivedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	var err error
	fo := &service.FindArchivedOptions{}

	o, err := ProtoToPtrServicesFindOptions(protoOptions.Options)
	if err != nil {
		return nil, err
	}
	if o != nil {
		fo.FindOptions = *o
	}

	return []*service.FindArchivedOptions{fo}, nil
}

func ElPtrUnarchiveOptionsToProto() {
	panic("function not provided") // TODO: provide converter
}

func ProtoToElPtrUnarchiveOptions() {
	panic("function not provided") // TODO: provide converter
}

func ElPtrIntrospectOptionsToProto() {
	panic("function not provided") // TODO: provide converter
}

func ProtoToElPtrIntrospectOptions() {
	panic("function not provided") // TODO: provide converter
}

func ProtoToPtrServicesAggregateOptions(protoOpts *pb.AggregateOptions) ([]*service.AggregateOptions, error) {
	if protoOpts == nil {
		return nil, nil
	}
	return []*service.AggregateOptions{&service.AggregateOptions{Fields: protoOpts.Fields}}, nil
}

func PtrServicesAggregateOptionsToProto(opts *service.AggregateOptions) (*pb.AggregateOptions, error) {
	if opts == nil {
		return nil, nil
	}
	return &pb.AggregateOptions{
		Fields: opts.Fields,
	}, nil
}

func ElPtrAggregateOptionsToProto(options []*service.AggregateOptions) (*pb.AggregateOptions, error) {
	if options == nil {
		return nil, nil
	}
	opts := service.MergeAggregateOptions(options...)
	return PtrServicesAggregateOptionsToProto(opts)
}

func ProtoToPtrServicesAggregatePublishedOptions(protoOpts *pb.AggregatePublishedOptions) ([]*service.AggregatePublishedOptions, error) {
	if protoOpts == nil {
		return nil, nil
	}
	return []*service.AggregatePublishedOptions{&service.AggregatePublishedOptions{Fields: protoOpts.Fields}}, nil
}

func PtrServicesAggregatePublishedOptionsToProto(opts *service.AggregatePublishedOptions) (*pb.AggregatePublishedOptions, error) {
	if opts == nil {
		return nil, nil
	}
	return &pb.AggregatePublishedOptions{
		Fields: opts.Fields,
	}, nil
}

func ElPtrAggregatePublishedOptionsToProto(options []*service.AggregatePublishedOptions) (*pb.AggregatePublishedOptions, error) {
	if options == nil {
		return nil, nil
	}
	opts := service.MergeAggregatePublishedOptions(options...)
	return PtrServicesAggregatePublishedOptionsToProto(opts)
}

func PtrSchemaSchemaToProto(sch *schema.Schema) (string, error) {
	if sch == nil {
		return "", nil
	}
	res, err := jsoniter.MarshalToString(sch)
	if err != nil {
		return "", err
	}
	return res, nil
}

func ProtoToPtrSchemaSchema(protoSch string) (*schema.Schema, error) {
	if protoSch == "" {
		return nil, nil
	}
	sch := schema.New()
	err := sch.UnmarshalJSON([]byte(protoSch))
	if err != nil {
		return nil, fmt.Errorf("failed to decode schema. err: %s", err.Error())
	}
	return sch, nil
}

func ValidationErrorsToProto(errs []error) ([]*pbcommon.Error_BadRequest_FieldViolation, error) {
	if errs == nil {
		return nil, nil
	}

	var validationErrors []*pbcommon.Error_BadRequest_FieldViolation
	for _, err := range errs {

		var fieldError errors.FieldError
		if errors.As(err, &fieldError) {
			validationErrors = append(validationErrors, &pbcommon.Error_BadRequest_FieldViolation{
				Description: errors.Unwrap(fieldError).Error(),
				Field:       fieldError.Field(),
			})
		}
	}

	return validationErrors, nil
}

func ProtoToValidationErrors(protoErrs []*pbcommon.Error_BadRequest_FieldViolation) ([]error, error) {
	if protoErrs == nil {
		return nil, nil
	}

	var validationErrors []error
	for _, err := range protoErrs {
		validationErrors = append(validationErrors, errors.WithField(errors.New(err.Description), err.Field))
	}

	return validationErrors, nil
}
