// Code generated by microgen 0.9.1. DO NOT EDIT.

package transport

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/schema"
	"github.com/hashicorp/go-multierror"
	"google.golang.org/grpc/status"
)

func (set EndpointsSet) Create(arg0 context.Context, arg1 *items.Item, arg2 ...*items.CreateOptions) (res0 *items.Item, res1 error) {
	request := CreateRequest{
		Item: arg1,
		Opts: arg2,
	}
	response, res1 := set.CreateEndpoint(arg0, &request)
	if res1 != nil {
		return
	}
	return response.(*CreateResponse).Created, res1
}

func (set EndpointsSet) Introspect(arg0 context.Context, arg1 *items.Item, arg2 ...*items.IntrospectOptions) (res0 *items.Item, res1 *schema.Schema, res2 error) {
	request := IntrospectRequest{
		Item: arg1,
		Opts: arg2,
	}
	response, res2 := set.IntrospectEndpoint(arg0, &request)
	if res2 != nil {
		return
	}
	resp := response.(*IntrospectResponse)

	if len(resp.ValidationErrors) > 0 {
		var merr *multierror.Error
		for _, err := range resp.ValidationErrors {
			var fieldErr errors.FieldError
			if errors.As(err, &fieldErr) {
				merr = multierror.Append(merr, fieldErr)
			}
		}

		res2 = errors.Wrap(merr, "validation error")

	}
	return resp.Item, resp.Schema, res2
}

func (set EndpointsSet) Get(arg0 context.Context, arg1, arg2, arg3, arg4 string, arg5 ...*items.GetOptions) (res0 *items.Item, res1 error) {
	request := GetRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		ItemId:       arg4,
		SpaceId:      arg1,
		Options:      arg5,
	}
	response, res1 := set.GetEndpoint(arg0, &request)
	if res1 != nil {
		return
	}
	return response.(*GetResponse).Item, res1
}

func (set EndpointsSet) Find(arg0 context.Context, arg1, arg2, arg3 string, arg4 *items.Filter, arg5 ...*items.FindOptions) (res0 []*items.Item, res1 int, res2 error) {
	request := FindRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		Filter:       arg4,
		Options:      arg5,
		SpaceId:      arg1,
	}
	response, res2 := set.FindEndpoint(arg0, &request)
	if res2 != nil {
		return
	}
	return response.(*FindResponse).Items, response.(*FindResponse).Total, res2
}

func (set EndpointsSet) Update(arg0 context.Context, arg1 *items.Item, arg2 ...*items.UpdateOptions) (res0 error) {
	request := UpdateRequest{Item: arg1, Options: arg2}
	_, res0 = set.UpdateEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) Delete(arg0 context.Context, arg1 *items.Item, arg2 ...*items.DeleteOptions) (res0 error) {
	request := DeleteRequest{Item: arg1, Options: arg2}
	_, res0 = set.DeleteEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) Undelete(arg0 context.Context, arg1 *items.Item, options ...*items.UndeleteOptions) (res0 error) {
	request := UndeleteRequest{Item: arg1, Options: options}
	_, res0 = set.UndeleteEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) Publish(arg0 context.Context, arg1 *items.Item, arg2 ...*items.PublishOptions) (res0 error) {
	request := PublishRequest{Item: arg1, Options: arg2}
	_, res0 = set.PublishEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) Unpublish(arg0 context.Context, arg1 *items.Item, arg2 ...*items.UnpublishOptions) (res0 error) {
	request := UnpublishRequest{Item: arg1, Options: arg2}
	_, res0 = set.UnpublishEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) GetPublished(arg0 context.Context, arg1, arg2, arg3, arg4 string, arg5 ...*items.GetPublishedOptions) (res0 *items.Item, res1 error) {
	request := GetPublishedRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		ItemId:       arg4,
		SpaceId:      arg1,
		Options:      arg5,
	}
	response, res1 := set.GetPublishedEndpoint(arg0, &request)
	if res1 != nil {
		return
	}
	return response.(*GetPublishedResponse).Item, res1
}

func (set EndpointsSet) FindPublished(arg0 context.Context, arg1, arg2, arg3 string, arg4 *items.Filter, arg5 ...*items.FindPublishedOptions) (res0 []*items.Item, res1 int, res2 error) {
	request := FindPublishedRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		Filter:       arg4,
		Options:      arg5,
		SpaceId:      arg1,
	}
	response, res2 := set.FindPublishedEndpoint(arg0, &request)
	if res2 != nil {
		return
	}
	return response.(*FindPublishedResponse).Items, response.(*FindPublishedResponse).Total, res2
}

func (set EndpointsSet) GetRevision(arg0 context.Context, arg1 string, arg2 string, arg3 string, arg4 string, arg5 string, arg6 ...*items.GetRevisionOptions) (res0 *items.Item, res1 error) {
	request := GetRevisionRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		ItemId:       arg4,
		RevisionId:   arg5,
		SpaceId:      arg1,
		Options:      arg6,
	}
	response, res1 := set.GetRevisionEndpoint(arg0, &request)
	if res1 != nil {
		return
	}
	return response.(*GetRevisionResponse).Item, res1
}

func (set EndpointsSet) ListRevisions(arg0 context.Context, arg1, arg2, arg3, arg4 string, arg5 ...*items.ListRevisionsOptions) (res0 []*items.Item, res1 error) {
	request := ListRevisionsRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		ItemId:       arg4,
		SpaceId:      arg1,
		Options:      arg5,
	}
	response, res1 := set.ListRevisionsEndpoint(arg0, &request)
	if res1 != nil {
		return
	}
	return response.(*ListRevisionsResponse).Items, res1
}

func (set EndpointsSet) Archive(arg0 context.Context, arg1 *items.Item, arg2 ...*items.ArchiveOptions) (res0 error) {
	request := ArchiveRequest{Item: arg1, Options: arg2}
	_, res0 = set.ArchiveEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) FindArchived(arg0 context.Context, arg1, arg2, arg3 string, arg4 *items.Filter, arg5 ...*items.FindArchivedOptions) (res0 []*items.Item, res1 int, res2 error) {
	request := FindArchivedRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		Options:      arg5,
		Filter:       arg4,
		SpaceId:      arg1,
	}
	response, res2 := set.FindArchivedEndpoint(arg0, &request)
	if res2 != nil {
		return
	}
	return response.(*FindArchivedResponse).Items, response.(*FindArchivedResponse).Total, res2
}

func (set EndpointsSet) Unarchive(arg0 context.Context, arg1 *items.Item, arg2 ...*items.UnarchiveOptions) (res0 error) {
	request := UnarchiveRequest{Item: arg1, Options: arg2}
	_, res0 = set.UnarchiveEndpoint(arg0, &request)
	if res0 != nil {
		return
	}
	return res0
}

func (set EndpointsSet) Aggregate(arg0 context.Context, arg1, arg2, arg3 string, arg4 *items.Filter, arg5 ...*items.AggregateOptions) (res0 map[string]interface{}, res1 error) {
	request := AggregateRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		Filter:       arg4,
		Options:      arg5,
		SpaceId:      arg1,
	}
	response, res1 := set.AggregateEndpoint(arg0, &request)
	if res1 != nil {
		return
	}
	return response.(*AggregateResponse).Result, res1
}

func (set EndpointsSet) AggregatePublished(arg0 context.Context, arg1, arg2, arg3 string, arg4 *items.Filter, arg5 ...*items.AggregatePublishedOptions) (res0 map[string]interface{}, res1 error) {
	request := AggregatePublishedRequest{
		CollectionId: arg3,
		EnvId:        arg2,
		Filter:       arg4,
		Options:      arg5,
		SpaceId:      arg1,
	}
	response, res1 := set.AggregatePublishedEndpoint(arg0, &request)

	if res1 != nil {
		if e, ok := status.FromError(res1); ok {
			res1 = errors.New(e.Message())
		}
		return
	}
	return response.(*AggregatePublishedResponse).Result, res1
}
