package items

import "git.perx.ru/perxis/perxis-go/pkg/options"

type Options struct {
	Env               map[string]interface{}
	Filter            []string
	PermissionsFilter []string
}

func MergeOptions(opts ...Options) Options {
	o := Options{
		Env:    make(map[string]interface{}),
		Filter: make([]string, 0),
	}

	for _, opt := range opts {

		for k, v := range opt.Env {
			o.Env[k] = v
		}

		o.Filter = append(o.Filter, opt.Filter...)
		o.PermissionsFilter = append(o.PermissionsFilter, opt.PermissionsFilter...)
	}

	return o
}

type CreateOptions struct {
	Options

	UpdateAttrs bool
}

func MergeCreateOptions(opts ...*CreateOptions) *CreateOptions {
	o := &CreateOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		if opt.UpdateAttrs {
			o.UpdateAttrs = true
		}

		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type IntrospectOptions struct {
	Options
	Locale string
}

func MergeIntrospectOptions(opts ...*IntrospectOptions) *IntrospectOptions {
	o := &IntrospectOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type GetOptions struct {
	Options
}

func MergeGetOptions(opts ...*GetOptions) *GetOptions {
	o := &GetOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type FindOptions struct {
	Options
	options.FindOptions
	Deleted   bool
	Regular   bool
	Hidden    bool
	Templates bool
}

func NewFindOptions(opts ...interface{}) *FindOptions {
	fo := &FindOptions{}
	fo.FindOptions = *options.MergeFindOptions(opts...)
	return fo
}

func MergeFindOptions(opts ...*FindOptions) *FindOptions {
	o := NewFindOptions()
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Regular = o.Regular || opt.Regular
		o.Templates = o.Templates || opt.Templates
		o.Hidden = o.Hidden || opt.Hidden
		o.Deleted = o.Deleted || opt.Deleted
		o.Options = MergeOptions(o.Options, opt.Options)
		o.FindOptions = *options.MergeFindOptions(&o.FindOptions, &opt.FindOptions)
	}
	return o
}

type UpdateOptions struct {
	Options

	UpdateAttrs bool
}

func MergeUpdateOptions(opts ...*UpdateOptions) *UpdateOptions {
	o := &UpdateOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		if opt.UpdateAttrs {
			o.UpdateAttrs = true
		}

		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type DeleteOptions struct {
	Options

	UpdateAttrs bool
	Erase       bool
}

func MergeDeleteOptions(options ...*DeleteOptions) *DeleteOptions {
	o := &DeleteOptions{}
	for _, opt := range options {
		if opt == nil {
			continue
		}
		if opt.UpdateAttrs {
			o.UpdateAttrs = true
		}
		if opt.Erase {
			o.Erase = true
		}

		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type SoftDeleteOptions struct {
	Options
}

func MergeSoftDeleteOptions(opts ...*SoftDeleteOptions) *SoftDeleteOptions {
	o := &SoftDeleteOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type UndeleteOptions struct {
	Options

	UpdateAttrs bool
}

func MergeUndeleteOptions(opts ...*UndeleteOptions) *UndeleteOptions {
	o := &UndeleteOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		if opt.UpdateAttrs {
			o.UpdateAttrs = true
		}

		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type PublishOptions struct {
	Options

	UpdateAttrs bool
}

func MergePublishOptions(opts ...*PublishOptions) *PublishOptions {
	o := &PublishOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		if opt.UpdateAttrs {
			o.UpdateAttrs = true
		}

		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type UnpublishOptions struct {
	UpdateAttrs bool

	Options
}

func MergeUnpublishOptions(opts ...*UnpublishOptions) *UnpublishOptions {
	o := &UnpublishOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		if opt.UpdateAttrs {
			o.UpdateAttrs = true
		}

		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type GetPublishedOptions struct {
	Options
	LocaleID string
}

func NewGetPublishedOptions(oo ...interface{}) *GetPublishedOptions {
	fo := &GetPublishedOptions{}
	for _, o := range oo {
		switch o := o.(type) {
		case string:
			fo.LocaleID = o
		}
	}
	return fo
}

func MergeGetPublishedOptions(opts ...*GetPublishedOptions) *GetPublishedOptions {
	o := &GetPublishedOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
		if opt.LocaleID != "" {
			o.LocaleID = opt.LocaleID
		}
	}
	return o
}

type FindPublishedOptions struct {
	Options
	options.FindOptions
	LocaleID  string
	Regular   bool
	Hidden    bool
	Templates bool
}

func NewFindPublishedOptions(opts ...interface{}) *FindPublishedOptions {
	fo := &FindPublishedOptions{}
	for _, o := range opts {
		switch o := o.(type) {
		case string:
			fo.LocaleID = o
		}
	}

	fo.FindOptions = *options.MergeFindOptions(opts...)
	return fo
}

func MergeFindPublishedOptions(opts ...*FindPublishedOptions) *FindPublishedOptions {
	o := NewFindPublishedOptions()
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Regular = o.Regular || opt.Regular
		o.Templates = o.Templates || opt.Templates
		o.Hidden = o.Hidden || opt.Hidden
		o.Options = MergeOptions(o.Options, opt.Options)
		o.FindOptions = *options.MergeFindOptions(&o.FindOptions, &opt.FindOptions)

		if opt.LocaleID != "" {
			o.LocaleID = opt.LocaleID
		}
	}
	return o
}

type GetRevisionOptions struct {
	Options
}

func MergeGetRevisionOptions(opts ...*GetRevisionOptions) *GetRevisionOptions {
	o := &GetRevisionOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type ListRevisionsOptions struct {
	Options
	options.FindOptions
}

func MergeListRevisionsOptions(opts ...*ListRevisionsOptions) *ListRevisionsOptions {
	o := &ListRevisionsOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
		o.FindOptions = *options.MergeFindOptions(&o.FindOptions, &opt.FindOptions)
	}
	return o
}

type ArchiveOptions struct {
	Options
}

func MergeArchiveOptions(opts ...*ArchiveOptions) *ArchiveOptions {
	o := &ArchiveOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type FindArchivedOptions struct {
	Options
	options.FindOptions
}

func NewFindArchivedOptions(oo ...interface{}) *FindArchivedOptions {
	fo := &FindArchivedOptions{}
	fo.FindOptions = *options.MergeFindOptions(oo...)
	return fo
}

func MergeFindArchivedOptions(opts ...*FindArchivedOptions) *FindArchivedOptions {
	o := NewFindArchivedOptions()
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
		o.FindOptions = *options.MergeFindOptions(o.FindOptions, opt.FindOptions)
	}
	return o
}

type UnarchiveOptions struct {
	Options
}

func MergeUnarchiveOptions(opts ...*UnarchiveOptions) *UnarchiveOptions {
	o := &UnarchiveOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)
	}
	return o
}

type AggregateOptions struct {
	Options
	options.SortOptions

	// Fields поля которые должны быть возвращены или вычислены в результате.
	// Ключ (string) - имя поля под которым будет добавляться результат.
	// Значение (string) - является выражением, вычисление которого сформирует результат
	// Функции для выражений (для поля F, типа T):
	// - distinct(F) - все значения поля, тип результат []T
	// - min(F) - минимальное значение поля, тип результат T
	// - max(F) - максимальное значение поля, тип результат T
	// - avg(F) - среднее значения поля, тип результат T
	// - sum(F) - сумма значений поля, тип результат T
	// - count() - число записей, тип результат int
	Fields map[string]string
}

func MergeAggregateOptions(opts ...*AggregateOptions) *AggregateOptions {
	o := &AggregateOptions{}
	for _, opt := range opts {
		if opt == nil {
			continue
		}
		o.Options = MergeOptions(o.Options, opt.Options)

		if o.Fields == nil {
			o.Fields = opt.Fields
			continue
		}
		for k, v := range opt.Fields {
			o.Fields[k] = v
		}
	}
	return o
}

type AggregatePublishedOptions AggregateOptions

func MergeAggregatePublishedOptions(opts ...*AggregatePublishedOptions) *AggregatePublishedOptions {
	ao := make([]*AggregateOptions, len(opts))
	for i, opt := range opts {
		ao[i] = (*AggregateOptions)(opt)
	}
	merged := MergeAggregateOptions(ao...)
	return (*AggregatePublishedOptions)(merged)
}
