package items

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/clients"
	"git.perx.ru/perxis/perxis-go/pkg/environments"
	"git.perx.ru/perxis/perxis-go/pkg/spaces"
)

type Context struct {
	Items
	Clients clients.Clients

	SpaceID      string
	EnvID        string
	CollectionID string
	ItemID       string
	Item         *Item
	Space        *spaces.Space
	Environment  *environments.Environment

	ViewSpaceID       string
	ViewEnvironmentID string
	ViewCollectionID  string
	ViewSpace         *spaces.Space
	ViewEnvironment   *environments.Environment
}

type itemsCtx struct{}

func WithContext(ctx context.Context, itmCtx *Context) context.Context {
	if ctx == nil {
		ctx = context.Background()
	}

	if itmCtx.ViewSpaceID == "" {
		itmCtx.ViewSpaceID = itmCtx.SpaceID
	}
	if itmCtx.ViewEnvironmentID == "" {
		itmCtx.ViewEnvironmentID = itmCtx.EnvID
	}
	if itmCtx.ViewCollectionID == "" {
		itmCtx.ViewCollectionID = itmCtx.CollectionID
	}
	if itmCtx.ViewSpace == nil {
		itmCtx.ViewSpace = itmCtx.Space
	}
	if itmCtx.ViewEnvironment == nil {
		itmCtx.ViewEnvironment = itmCtx.Environment
	}

	p, _ := ctx.Value(itemsCtx{}).(*Context)
	if p != nil {
		*p = *itmCtx
		return ctx
	}

	return context.WithValue(ctx, itemsCtx{}, itmCtx)
}

func GetContext(ctx context.Context) *Context {
	if ctx == nil {
		return new(Context)
	}
	p, _ := ctx.Value(itemsCtx{}).(*Context)
	if p == nil {
		return new(Context)
	}
	return p
}
