package invitations

import "time"

const InvitationTTL = 7 * 24 * time.Hour

type Invitation struct {
	ID         string     `bson:"_id"`
	Email      string     `bson:"email"`
	OrgID      string     `bson:"orgId"`
	SpaceID    string     `bson:"spaceId"`
	OwnerID    string     `bson:"ownerId"` // Invitation owner
	Role       string     `bson:"role"`
	CreatedAt  *time.Time `bson:"createdAt"`
	ValidUntil *time.Time `bson:"validUntil"`
}
