package images

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/files"
)

// Images - описывает интерфейс сервиса для обработки изображений
// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/images
type Images interface {

	// Get - к файлу, идентификатор которого передан в запросе, применяются параметры.
	// Может быть передано несколько параметров, порядок учитывается при обработке
	// Допустимые операции:
	//  - crop (ширина, высота)
	//  - fit (ширина, высота)
	//  - resize (ширина, высота)
	//  - format (один из форматов [ png, jpeg, jpg, gif ]
	// Возвращает объект File с заполненным полем File.URL
	Get(ctx context.Context, source *files.File, opts *GetOptions) (result *files.File, err error)
}

type GetOptions struct {
	Params []*Param
}

type Param struct {
	Op    string
	Value []string
}
