// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/access_log
// gowrap: http://github.com/hexdigest/gowrap

package middleware

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/files -i Files -t ../../../assets/templates/middleware/access_log -o logging_middleware.go -l ""

import (
	"context"
	"fmt"
	"time"

	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/files"
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

// loggingMiddleware implements files.Files that is instrumented with logging
type loggingMiddleware struct {
	logger *zap.Logger
	next   files.Files
}

// LoggingMiddleware instruments an implementation of the files.Files with simple logging
func LoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next files.Files) files.Files {
		return &loggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *loggingMiddleware) AbortUpload(ctx context.Context, upload *files.MultipartUpload) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"upload": upload} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("AbortUpload.Request", fields...)

	err = m.next.AbortUpload(ctx, upload)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("AbortUpload.Response", fields...)

	return err
}

func (m *loggingMiddleware) CompleteUpload(ctx context.Context, upload *files.MultipartUpload) (u *files.MultipartUpload, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"upload": upload} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("CompleteUpload.Request", fields...)

	u, err = m.next.CompleteUpload(ctx, upload)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"u":   u,
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("CompleteUpload.Response", fields...)

	return u, err
}

func (m *loggingMiddleware) DeleteFile(ctx context.Context, file *files.File) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":  ctx,
		"file": file} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("DeleteFile.Request", fields...)

	err = m.next.DeleteFile(ctx, file)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("DeleteFile.Response", fields...)

	return err
}

func (m *loggingMiddleware) GetFile(ctx context.Context, file *files.File) (f *files.File, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":  ctx,
		"file": file} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("GetFile.Request", fields...)

	f, err = m.next.GetFile(ctx, file)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"f":   f,
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("GetFile.Response", fields...)

	return f, err
}

func (m *loggingMiddleware) MoveUpload(ctx context.Context, upload *files.MultipartUpload) (file *files.File, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"upload": upload} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("MoveUpload.Request", fields...)

	file, err = m.next.MoveUpload(ctx, upload)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"file": file,
		"err":  err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("MoveUpload.Response", fields...)

	return file, err
}

func (m *loggingMiddleware) StartUpload(ctx context.Context, upload *files.MultipartUpload) (u *files.MultipartUpload, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"upload": upload} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("StartUpload.Request", fields...)

	u, err = m.next.StartUpload(ctx, upload)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"u":   u,
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("StartUpload.Response", fields...)

	return u, err
}

func (m *loggingMiddleware) Upload(ctx context.Context, file *files.File) (u *files.Upload, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":  ctx,
		"file": file} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Upload.Request", fields...)

	u, err = m.next.Upload(ctx, file)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"u":   u,
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Upload.Response", fields...)

	return u, err
}
