package extension

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
	pb "git.perx.ru/perxis/perxis-go/proto/extensions"
	"google.golang.org/grpc"
)

type Client struct {
	client pb.ExtensionClient
}

func NewClient(conn *grpc.ClientConn) *Client {
	return &Client{
		client: pb.NewExtensionClient(conn),
	}
}

func (c Client) GetDescriptor() *ExtensionDescriptor {
	return nil
}

type results interface {
	GetResults() []*RequestResult
}

func getErrors(out results, err, wrapErr error) error {
	if err != nil {
		return err
	}

	res := out.GetResults()

	var errs []error
	for _, r := range res {
		if r.State == RequestError {
			err := errors.New(r.GetError())
			if msg := r.GetMsg(); msg != "" {
				err = errors.WithDetail(err, msg)
			}
			errs = append(errs, ExtensionError(err, r.Extension))
		}

		if r.UpdateAvailable {
			errs = append(errs, ExtensionError(ErrUpdateAvailable, r.Extension))
		}
	}

	if len(errs) > 0 {
		return errors.WithErrors(wrapErr, errs...)
	}

	return nil
}

func (c Client) Install(ctx context.Context, in *InstallRequest) error {
	out, err := c.client.Install(ctx, in)
	return getErrors(out, err, ErrInstall)
}

func (c Client) Check(ctx context.Context, in *CheckRequest) error {
	out, err := c.client.Check(ctx, in)
	return getErrors(out, err, ErrCheck)
}

func (c Client) Update(ctx context.Context, in *UpdateRequest) error {
	out, err := c.client.Update(ctx, in)
	return getErrors(out, err, ErrUpdate)
}

func (c Client) Uninstall(ctx context.Context, in *UninstallRequest) error {
	out, err := c.client.Uninstall(ctx, in)
	return getErrors(out, err, ErrUninstall)
}

func (c Client) Action(ctx context.Context, in *ActionRequest) (*ActionResponse, error) {
	out, err := c.client.Action(ctx, in)
	return out, err
	//return ActionResponseFromPB(out), err
}
