package expr

import "strings"

func init() {
	RegisterOption(
		Extend("icontains", IContains),
		Extend("istartsWith", IStartsWith),
		Extend("iendsWith", IEndsWith),
	)
}

func IContains(v1, v2 interface{}) bool {
	s1, ok := v1.(string)
	if !ok {
		return false
	}
	s2, ok := v2.(string)
	if !ok {
		return false
	}

	return strings.Contains(strings.ToLower(s1), strings.ToLower(s2))
}

func IStartsWith(v1, v2 interface{}) bool {
	s1, ok := v1.(string)
	if !ok {
		return false
	}
	s2, ok := v2.(string)
	if !ok {
		return false
	}

	return strings.HasPrefix(strings.ToLower(s1), strings.ToLower(s2))
}

func IEndsWith(v1, v2 interface{}) bool {
	s1, ok := v1.(string)
	if !ok {
		return false
	}
	s2, ok := v2.(string)
	if !ok {
		return false
	}

	return strings.HasSuffix(strings.ToLower(s1), strings.ToLower(s2))
}
