package expr

func init() {
	RegisterOption(
		Extend("In", In),
	)
}

func In(v1, v2 interface{}) bool {
	if v1 == nil || v2 == nil {
		return false
	}

	s1, ok1 := v1.([]interface{})
	s2, ok2 := v2.([]interface{})

	switch {
	case ok1 && ok2:
		return sliceInSlice(s1, s2)
	case ok1 && !ok2:
		return valueInSlice(v2, s1)
	case !ok1 && ok2:
		return valueInSlice(v1, s2)
	case !ok1 && !ok2:
		return v1 == v2
	}

	return false
}

func sliceInSlice(s1, s2 []interface{}) bool {
	for _, v1 := range s1 {
		if valueInSlice(v1, s2) {
			return true
		}
	}
	return false
}

func valueInSlice(v interface{}, s []interface{}) bool {
	for _, e := range s {
		if e == v {
			return true
		}
	}
	return false
}
