package events

type Subscription interface {
	Unsubscribe() error
}

type Connection interface {
	Publish(subject string, msg any, opts ...PublishOption) error
	Subscribe(subject string, handler any, opts ...SubscribeOption) (Subscription, error)
	Close() error
}

type PublishOptions struct {
	Tags []string
}

func NewPublishOptions(opts ...PublishOption) *PublishOptions {
	o := &PublishOptions{}
	for _, opt := range opts {
		if opt != nil {
			opt(o)
		}
	}
	return o
}

type PublishOption func(options *PublishOptions)

func Tag(tag ...string) PublishOption {
	return func(o *PublishOptions) {
		o.Tags = tag
	}
}

type SubscribeOptions struct {
	FilterTags []string
}

func NewSubscribeOptions(opts ...SubscribeOption) *SubscribeOptions {
	o := &SubscribeOptions{}
	for _, opt := range opts {
		if opt != nil {
			opt(o)
		}
	}
	return o
}

type SubscribeOption func(options *SubscribeOptions)

func FilterTag(tag ...string) SubscribeOption {
	return func(o *SubscribeOptions) {
		o.FilterTags = tag
	}
}
