package errors

//
//import (
//	"fmt"
//	"testing"
//
//	jsoniter "github.com/json-iterator/go"
//	"github.com/perxteam/hoop4/yaml"
//	"github.com/stretchr/testify/assert"
//	"github.com/stretchr/testify/require"
//)
//
//func TestErrors_OmitemptyError(t *testing.T) {
//	type Struct struct {
//		Some  string `json:"some"`
//		Error error  `json:"error,omitempty"`
//	}
//
//	s := &Struct{Some: "Some"}
//	b, err := jsoniter.Marshal(s)
//	require.NoError(t, err)
//
//	var ss Struct
//	err = jsoniter.Unmarshal(b, &ss)
//	require.NoError(t, err)
//}
//
//func TestErrors_EmptyError(t *testing.T) {
//	type Struct struct {
//		Some  string `json:"some"`
//		Error error  `json:"error"`
//	}
//
//	s := &Struct{Some: "Some"}
//	b, err := jsoniter.Marshal(s)
//	require.NoError(t, err)
//
//	var ss Struct
//	err = jsoniter.Unmarshal(b, &ss)
//	require.NoError(t, err)
//}
//
//func TestErrors_MarshalYAML(t *testing.T) {
//	type S struct {
//		Error error
//	}
//	l1 := &S{New("test")}
//
//	_, err := yaml.Marshal(l1)
//	require.NoError(t, err)
//}
//
//func TestErrors_Encode(t *testing.T) {
//	e := Global(WithID(New("test")))
//	e = WithStack(e)
//	e = NotFound(e)
//	e = fmt.Errorf("Got error %w", e)
//	e = WithDetail(WithHint(e, "Hint"), "Detail")
//	e = WithErrors(e, New("add1"), New("add2"))
//	enc := EncodeError(e)
//	err := DecodeError(enc)
//
//	assert.True(t, IsNotFound(err))
//	assert.Equal(t, "Got error test", err.Error())
//	assert.True(t, Is(err, New("Got error test")))
//	assert.Equal(t, "Hint", GetHint(err))
//	assert.Equal(t, "Detail", GetDetail(err))
//	assert.NotEmpty(t, GetID(err))
//	assert.Equal(t, GetID(e), GetID(err))
//	assert.Equal(t, GlobalDomain, GetDomain(err))
//	errs := GetErrors(err)
//	require.Len(t, errs, 2)
//	assert.True(t, Is(errs[0], New("add1")))
//	assert.True(t, Is(errs[1], New("add2")))
//}
//
//func TestErrors_JSONEncode(t *testing.T) {
//	type Struct struct {
//		Some  string `json:"some"`
//		Error error  `json:"error,omitempty"`
//	}
//
//	s := &Struct{Some: "Some"}
//	e := Global(WithID(New("test")))
//	e = WithStack(e)
//	e = NotFound(e)
//	e = fmt.Errorf("Got error %w", e)
//	e = WithDetail(WithHint(e, "Hint"), "Detail")
//	e = WithErrors(e, New("add1"), New("add2"))
//	s.Error = e
//
//	b, jerr := jsoniter.Marshal(s)
//	require.NoError(t, jerr)
//
//	var st Struct
//	jerr = jsoniter.Unmarshal(b, &st)
//	require.NoError(t, jerr)
//	err := st.Error
//
//	assert.True(t, IsNotFound(err))
//	assert.Equal(t, "Got error test", err.Error())
//	assert.True(t, Is(err, New("Got error test")))
//	assert.Equal(t, "Hint", GetHint(err))
//	assert.Equal(t, "Detail", GetDetail(err))
//	assert.NotEmpty(t, GetID(err))
//	assert.Equal(t, GetID(e), GetID(err))
//	assert.Equal(t, GlobalDomain, GetDomain(err))
//	errs := GetErrors(err)
//	require.Len(t, errs, 2)
//	assert.True(t, Is(errs[0], New("add1")))
//	assert.True(t, Is(errs[1], New("add2")))
//}
//
//func TestErrors_MultiErrors(t *testing.T) {
//	err := WithErrors(New("main"), New("add1"), New("add2"))
//	errs := GetErrors(err)
//	require.Len(t, errs, 2)
//	assert.True(t, Is(errs[0], New("add1")))
//	assert.True(t, Is(errs[1], New("add2")))
//	assert.Equal(t, "main", err.Error())
//}
//
////func TestErrors_NotFound(t *testing.T) {
////	e := NotFound(New("test"))
////	fmt.Println(IsNotFound(e))
////	enc := EncodeError(e)
////	fmt.Printf("%#v", enc)
////	//require.NoError(t, e)
////}
//
