package environments

import (
	"context"
)

// Environments
// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/environments
// @grpc-addr content.environments.Environments
type Environments interface {
	Create(ctx context.Context, env *Environment) (created *Environment, err error)
	Get(ctx context.Context, spaceId, envId string) (env *Environment, err error)
	List(ctx context.Context, spaceId string) (envs []*Environment, err error)
	Update(ctx context.Context, env *Environment) (err error)
	Delete(ctx context.Context, spaceId, envId string) (err error)
	SetAlias(ctx context.Context, spaceId, envId, alias string) (err error)
	RemoveAlias(ctx context.Context, spaceId, envId, alias string) (err error)
	Migrate(ctx context.Context, spaceId, envId string, options ...*MigrateOptions) (err error)
}
