package environments

import (
	"git.perx.ru/perxis/perxis-go/pkg/errors"
	"git.perx.ru/perxis/perxis-go/pkg/service"
)

var (
	ErrAccessDenied    = service.ErrAccessDenied
	ErrNotFound        = service.ErrNotFound
	ErrAlreadyExists   = service.ErrAlreadyExists
	ErrMigrateConflict = errors.WithHintf(
		errors.New("cannot migrate while environment is preparing"),
		"Дождитесь, пока процессы подготовки пространства завершатся и оно перейдет в состояние '%s'/'%s'", StateReady, StateError,
	)
	ErrEnvironmentUnavailable = errors.New("environment is unavailable")
)
