// Code generated by microgen 0.9.1. DO NOT EDIT.

// It is better for you if you do not change functions names!
// This file will never be overwritten.
package transportgrpc

import (
	"fmt"

	collections "git.perx.ru/perxis/perxis-go/pkg/collections"
	environments "git.perx.ru/perxis/perxis-go/pkg/environments"
	"git.perx.ru/perxis/perxis-go/pkg/filter"
	items "git.perx.ru/perxis/perxis-go/pkg/items"
	locales "git.perx.ru/perxis/perxis-go/pkg/locales"
	services "git.perx.ru/perxis/perxis-go/pkg/options"
	"git.perx.ru/perxis/perxis-go/pkg/schema"
	collectionspb "git.perx.ru/perxis/perxis-go/proto/collections"
	"git.perx.ru/perxis/perxis-go/proto/common"
	"git.perx.ru/perxis/perxis-go/proto/delivery"
	environmentspb "git.perx.ru/perxis/perxis-go/proto/environments"
	itemspb "git.perx.ru/perxis/perxis-go/proto/items"
	localespb "git.perx.ru/perxis/perxis-go/proto/locales"
	"github.com/golang/protobuf/ptypes"
	"google.golang.org/protobuf/types/known/structpb"
)

func ListPtrLocalesLocaleToProto(locales []*locales.Locale) ([]*localespb.Locale, error) {
	protoLocales := make([]*localespb.Locale, 0, len(locales))
	for _, l := range locales {
		protoLocales = append(protoLocales, &localespb.Locale{Id: l.ID, Name: l.Name, SpaceId: l.SpaceID})
	}
	return protoLocales, nil
}

func ProtoToListPtrLocalesLocale(protoLocales []*localespb.Locale) ([]*locales.Locale, error) {
	ls := make([]*locales.Locale, 0, len(protoLocales))
	for _, pl := range protoLocales {
		ls = append(ls, &locales.Locale{ID: pl.Id, Name: pl.Name, SpaceID: pl.SpaceId})
	}
	return ls, nil
}

func PtrEnvironmentsEnvironmentToProto(env *environments.Environment) (*environmentspb.Environment, error) {
	if env == nil {
		return nil, nil
	}
	protoEnvironment := &environmentspb.Environment{
		Id:          env.ID,
		SpaceId:     env.SpaceID,
		Description: env.Description,
		Aliases:     env.Aliases,
	}
	if env.StateInfo != nil {
		protoEnvironment.StateInfo = &environmentspb.StateInfo{
			State: environmentspb.StateInfo_State(env.StateInfo.State),
			Info:  env.StateInfo.Info,
		}
		protoEnvironment.StateInfo.StartedAt, _ = ptypes.TimestampProto(env.StateInfo.StartedAt)
	}
	if env.Config != nil {
		protoEnvironment.Config = &environmentspb.Config{
			SourceId: env.Config.SourceID,
			Features: env.Config.Features,
		}
	}
	return protoEnvironment, nil
}

func ProtoToPtrEnvironmentsEnvironment(protoEnv *environmentspb.Environment) (*environments.Environment, error) {
	if protoEnv == nil {
		return nil, nil
	}
	env := &environments.Environment{
		ID:          protoEnv.Id,
		SpaceID:     protoEnv.SpaceId,
		Description: protoEnv.Description,
		Aliases:     protoEnv.Aliases,
	}
	if protoEnv.StateInfo != nil {
		env.StateInfo = &environments.StateInfo{
			State: environments.State(protoEnv.StateInfo.State),
			Info:  protoEnv.StateInfo.Info,
		}
		env.StateInfo.StartedAt, _ = ptypes.Timestamp(protoEnv.StateInfo.StartedAt)
	}
	if protoEnv.Config != nil {
		env.Config = &environments.Config{
			SourceID: protoEnv.Config.SourceId,
			Features: protoEnv.Config.Features,
		}
	}
	return env, nil
}

func ListPtrEnvironmentsEnvironmentToProto(envs []*environments.Environment) ([]*environmentspb.Environment, error) {
	protoEnvironments := make([]*environmentspb.Environment, 0, len(envs))
	for _, environment := range envs {
		protoEnvironment, err := PtrEnvironmentsEnvironmentToProto(environment)
		if err != nil {
			return nil, err
		}
		protoEnvironments = append(protoEnvironments, protoEnvironment)
	}
	return protoEnvironments, nil
}

func ProtoToListPtrEnvironmentsEnvironment(protoEnvs []*environmentspb.Environment) ([]*environments.Environment, error) {
	environments := make([]*environments.Environment, 0, len(protoEnvs))
	for _, protoEnvironment := range protoEnvs {
		environment, err := ProtoToPtrEnvironmentsEnvironment(protoEnvironment)
		if err != nil {
			return nil, err
		}
		environments = append(environments, environment)
	}
	return environments, nil
}

func PtrCollectionsCollectionToProto(collection *collections.Collection) (*collectionspb.Collection, error) {
	if collection == nil {
		return nil, nil
	}
	protoCollection := &collectionspb.Collection{
		Id:      collection.ID,
		SpaceId: collection.SpaceID,
		EnvId:   collection.EnvID,
		Name:    collection.Name,
		Single:  collection.Single,
		System:  collection.System,
	}
	if collection.Schema != nil {
		b, err := collection.Schema.MarshalJSON()
		if err != nil {
			return nil, err
		}
		protoCollection.Schema = string(b)
	}
	return protoCollection, nil
}

func ProtoToPtrCollectionsCollection(protoCollection *collectionspb.Collection) (*collections.Collection, error) {
	if protoCollection == nil {
		return nil, nil
	}
	collection := &collections.Collection{
		ID:      protoCollection.Id,
		SpaceID: protoCollection.SpaceId,
		EnvID:   protoCollection.EnvId,
		Name:    protoCollection.Name,
		Single:  protoCollection.Single,
		System:  protoCollection.System,
	}
	if protoCollection.Schema != "" {
		sch := schema.New()
		err := sch.UnmarshalJSON([]byte(protoCollection.Schema))
		if err != nil {
			return nil, fmt.Errorf("failed to decode schema. err: %s", err.Error())
		}
		collection.Schema = sch
	}
	return collection, nil
}

func ListPtrCollectionsCollectionToProto(collections []*collections.Collection) ([]*collectionspb.Collection, error) {
	protoCollections := make([]*collectionspb.Collection, 0, len(collections))
	for _, collection := range collections {
		protoCollection, err := PtrCollectionsCollectionToProto(collection)
		if err != nil {
			return nil, err
		}
		protoCollections = append(protoCollections, protoCollection)
	}
	return protoCollections, nil
}

func ProtoToListPtrCollectionsCollection(protoCollections []*collectionspb.Collection) ([]*collections.Collection, error) {
	collections := make([]*collections.Collection, 0, len(protoCollections))
	for _, protoCollection := range protoCollections {
		collection, err := ProtoToPtrCollectionsCollection(protoCollection)
		if err != nil {
			return nil, err
		}
		collections = append(collections, collection)
	}
	return collections, nil
}

func PtrItemsItemToProto(item *items.Item) (*itemspb.Item, error) {
	if item == nil {
		return nil, nil
	}

	protoItem := &itemspb.Item{
		Id:           item.ID,
		SpaceId:      item.SpaceID,
		EnvId:        item.EnvID,
		CollectionId: item.CollectionID,
		State:        itemspb.Item_State(item.State),
		CreatedBy:    item.CreatedBy,
		UpdatedBy:    item.UpdatedBy,
		RevisionId:   item.RevisionID,
		Locale:       item.Locale,
		//Hidden, Template, Deleted - не передается для delivery
	}

	var err error
	protoItem.Data, err = MapStringInterfaceToProto(item.Data)
	if err != nil {
		return nil, err
	}
	protoItem.Translations, err = MapStringMapStringInterfaceToProto(item.Translations)
	if err != nil {
		return nil, err
	}
	//protoItem.Permissions - не передается для delivery

	protoItem.CreatedRevAt, _ = ptypes.TimestampProto(item.CreatedRevAt)
	protoItem.CreatedAt, _ = ptypes.TimestampProto(item.CreatedAt)
	protoItem.UpdatedAt, _ = ptypes.TimestampProto(item.UpdatedAt)

	return protoItem, nil
}

func ProtoToPtrItemsItem(protoItem *itemspb.Item) (*items.Item, error) {
	if protoItem == nil {
		return nil, nil
	}

	item := &items.Item{
		ID:           protoItem.Id,
		SpaceID:      protoItem.SpaceId,
		EnvID:        protoItem.EnvId,
		CollectionID: protoItem.CollectionId,
		State:        items.State(protoItem.State),
		CreatedBy:    protoItem.CreatedBy,
		UpdatedBy:    protoItem.UpdatedBy,
		RevisionID:   protoItem.RevisionId,
		Locale:       protoItem.Locale,
		//Hidden, Template, Deleted - не передается для delivery
	}

	item.Data, _ = ProtoToMapStringInterface(protoItem.Data)
	item.Translations, _ = ProtoToMapStringMapStringInterface(protoItem.Translations)
	//item.Permissions - не передается для delivery

	item.CreatedRevAt, _ = ptypes.Timestamp(protoItem.CreatedRevAt)
	item.CreatedAt, _ = ptypes.Timestamp(protoItem.CreatedAt)
	item.UpdatedAt, _ = ptypes.Timestamp(protoItem.UpdatedAt)

	return item, nil
}

func PtrItemsFilterToProto(filter *items.Filter) (*itemspb.Filter, error) {
	if filter == nil {
		return nil, nil
	}

	dt := make([]*common.Filter, 0, len(filter.Data))
	for _, f := range filter.Data {
		pf := &common.Filter{
			Op:    string(f.Op),
			Field: f.Field,
		}

		val, err := structpb.NewValue(f.Value)
		if err != nil {
			return nil, err
		}
		pf.Value = val
		dt = append(dt, pf)
	}

	return &itemspb.Filter{
		Id:   filter.ID,
		Data: dt,
		Q:    filter.Q,
	}, nil
}

func ProtoToPtrItemsFilter(protoFilter *itemspb.Filter) (*items.Filter, error) {
	if protoFilter == nil {
		return nil, nil
	}

	dt := make([]*filter.Filter, 0, len(protoFilter.Data))
	for _, pf := range protoFilter.Data {

		f := &filter.Filter{
			Op:    filter.Op(pf.Op),
			Field: pf.Field,
			Value: pf.Value.AsInterface(),
		}

		dt = append(dt, f)
	}

	return &items.Filter{
		ID:   protoFilter.Id,
		Data: dt,
		Q:    protoFilter.Q,
	}, nil
}

func PtrServicesFindOptionsToProto(options *services.FindOptions) (*common.FindOptions, error) {
	if options == nil {
		return nil, nil
	}
	return &common.FindOptions{
		Sort:     options.Sort,
		PageNum:  int32(options.PageNum),
		PageSize: int32(options.PageSize),
	}, nil
}

func ProtoToPtrServicesFindOptions(protoOptions *common.FindOptions) (*services.FindOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return &services.FindOptions{
		SortOptions: services.SortOptions{
			Sort: protoOptions.Sort,
		},
		PaginationOptions: services.PaginationOptions{
			PageNum:  int(protoOptions.PageNum),
			PageSize: int(protoOptions.PageSize),
		},
	}, nil
}

func ListPtrItemsItemToProto(itms []*items.Item) ([]*itemspb.Item, error) {
	protoItems := make([]*itemspb.Item, 0, len(itms))
	for _, itm := range itms {
		pi, err := PtrItemsItemToProto(itm)
		if err != nil {
			return nil, err
		}
		protoItems = append(protoItems, pi)
	}
	return protoItems, nil
}

func ProtoToListPtrItemsItem(protoItems []*itemspb.Item) ([]*items.Item, error) {
	items := make([]*items.Item, 0, len(protoItems))
	for _, itm := range protoItems {
		pi, err := ProtoToPtrItemsItem(itm)
		if err != nil {
			return nil, err
		}
		items = append(items, pi)
	}
	return items, nil
}

func MapStringInterfaceToProto(data map[string]interface{}) (*structpb.Struct, error) {
	if data == nil {
		return nil, nil
	}
	return structpb.NewStruct(data)
}

func ProtoToMapStringInterface(protoData *structpb.Struct) (map[string]interface{}, error) {
	if protoData == nil {
		return nil, nil
	}
	return protoData.AsMap(), nil
}

func MapStringMapStringInterfaceToProto(translations map[string]map[string]interface{}) (map[string]*structpb.Struct, error) {
	if translations == nil {
		return nil, nil
	}
	res := make(map[string]*structpb.Struct, len(translations))
	for k, v := range translations {
		res[k], _ = MapStringInterfaceToProto(v)
	}
	return res, nil
}

func ProtoToMapStringMapStringInterface(protoTranslations map[string]*structpb.Struct) (map[string]map[string]interface{}, error) {
	if protoTranslations == nil {
		return nil, nil
	}
	res := make(map[string]map[string]interface{}, len(protoTranslations))
	for k, v := range protoTranslations {
		res[k], _ = ProtoToMapStringInterface(v)
	}
	return res, nil
}

func ElPtrItemsGetPublishedOptionsToProto(options []*items.GetPublishedOptions) (*itemspb.GetPublishedOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := items.MergeGetPublishedOptions(options...)

	return &itemspb.GetPublishedOptions{LocaleId: opts.LocaleID}, nil
}

func ProtoToElPtrItemsGetPublishedOptions(protoOptions *itemspb.GetPublishedOptions) ([]*items.GetPublishedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	return []*items.GetPublishedOptions{{LocaleID: protoOptions.LocaleId}}, nil
}

func ElPtrItemsFindPublishedOptionsToProto(options []*items.FindPublishedOptions) (*itemspb.FindPublishedOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := items.MergeFindPublishedOptions(options...)

	var err error

	fo := &itemspb.FindPublishedOptions{}

	fo.Options, err = PtrServicesFindOptionsToProto(&opts.FindOptions)
	if err != nil {
		return nil, err
	}

	fo.LocaleId = opts.LocaleID

	return fo, nil
}

func ProtoToElPtrItemsFindPublishedOptions(protoOptions *itemspb.FindPublishedOptions) ([]*items.FindPublishedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}

	var err error
	fo := &items.FindPublishedOptions{}

	o, err := ProtoToPtrServicesFindOptions(protoOptions.Options)
	if err != nil {
		return nil, err
	}
	if o != nil {
		fo.FindOptions = *o
	}

	fo.LocaleID = protoOptions.LocaleId

	return []*items.FindPublishedOptions{fo}, nil
}

func PtrServicesAggregateOptionsToProto(options *items.AggregatePublishedOptions) (*delivery.AggregateOptions, error) {
	if options == nil {
		return nil, nil
	}
	return &delivery.AggregateOptions{Fields: options.Fields}, nil
}

func ProtoToPtrServicesAggregateOptions(protoOptions *delivery.AggregateOptions) ([]*items.AggregatePublishedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*items.AggregatePublishedOptions{&items.AggregatePublishedOptions{Fields: protoOptions.Fields}}, nil
}

func ElPtrItemsAggregateOptionsToProto(options []*items.AggregatePublishedOptions) (*delivery.AggregateOptions, error) {
	if options == nil {
		return nil, nil
	}

	opts := items.MergeAggregatePublishedOptions(options...)
	return PtrServicesAggregateOptionsToProto(opts)
}

func ProtoToElPtrItemsAggregateOptions(protoOptions *delivery.AggregateOptions) ([]*items.AggregatePublishedOptions, error) {
	if protoOptions == nil {
		return nil, nil
	}
	return []*items.AggregatePublishedOptions{&items.AggregatePublishedOptions{Fields: protoOptions.Fields}}, nil
}
