package delivery

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/environments"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/locales"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/delivery
// @grpc-addr delivery.Delivery
type Delivery interface {
	ListLocales(ctx context.Context, spaceId string) (locales []*locales.Locale, err error)

	GetEnvironment(ctx context.Context, spaceId, envId string) (env *environments.Environment, err error)
	ListEnvironments(ctx context.Context, spaceId string) (envs []*environments.Environment, err error)

	GetCollection(ctx context.Context, spaceId, envId, collectionId string) (collection *collections.Collection, err error)
	ListCollections(ctx context.Context, spaceId, envId string) (collections []*collections.Collection, err error)

	GetItem(ctx context.Context, spaceId, envId, collectionId, itemId string, options ...*items.GetPublishedOptions) (item *items.Item, err error)
	FindItems(ctx context.Context, spaceId, envId, collectionId string, filter *items.Filter, options ...*items.FindPublishedOptions) (items []*items.Item, total int, err error)

	Aggregate(ctx context.Context, spaceId, envId, collectionId string, filter *items.Filter, options ...*items.AggregatePublishedOptions) (result map[string]interface{}, err error)
}
