// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/telemetry
// gowrap: http://github.com/hexdigest/gowrap

package middleware

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/delivery -i Delivery -t ../../../assets/templates/middleware/telemetry -o telemetry_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/delivery"
	"git.perx.ru/perxis/perxis-go/pkg/environments"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/locales"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
)

// telemetryMiddleware implements delivery.Delivery interface instrumented with opentracing spans
type telemetryMiddleware struct {
	delivery.Delivery
	_instance      string
	_spanDecorator func(span trace.Span, params, results map[string]interface{})
}

// TelemetryMiddleware returns telemetryMiddleware
func TelemetryMiddleware(base delivery.Delivery, instance string, spanDecorator ...func(span trace.Span, params, results map[string]interface{})) telemetryMiddleware {
	d := telemetryMiddleware{
		Delivery:  base,
		_instance: instance,
	}

	if len(spanDecorator) > 0 && spanDecorator[0] != nil {
		d._spanDecorator = spanDecorator[0]
	}

	return d
}

// Aggregate implements delivery.Delivery
func (_d telemetryMiddleware) Aggregate(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.AggregatePublishedOptions) (result map[string]interface{}, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.Aggregate")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"result": result,
				"err":    err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.Aggregate(ctx, spaceId, envId, collectionId, filter, options...)
}

// FindItems implements delivery.Delivery
func (_d telemetryMiddleware) FindItems(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.FindPublishedOptions) (items []*items.Item, total int, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.FindItems")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"items": items,
				"total": total,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.FindItems(ctx, spaceId, envId, collectionId, filter, options...)
}

// GetCollection implements delivery.Delivery
func (_d telemetryMiddleware) GetCollection(ctx context.Context, spaceId string, envId string, collectionId string) (collection *collections.Collection, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.GetCollection")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId}, map[string]interface{}{
				"collection": collection,
				"err":        err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.GetCollection(ctx, spaceId, envId, collectionId)
}

// GetEnvironment implements delivery.Delivery
func (_d telemetryMiddleware) GetEnvironment(ctx context.Context, spaceId string, envId string) (env *environments.Environment, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.GetEnvironment")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId,
				"envId":   envId}, map[string]interface{}{
				"env": env,
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.GetEnvironment(ctx, spaceId, envId)
}

// GetItem implements delivery.Delivery
func (_d telemetryMiddleware) GetItem(ctx context.Context, spaceId string, envId string, collectionId string, itemId string, options ...*items.GetPublishedOptions) (item *items.Item, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.GetItem")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"itemId":       itemId,
				"options":      options}, map[string]interface{}{
				"item": item,
				"err":  err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.GetItem(ctx, spaceId, envId, collectionId, itemId, options...)
}

// ListCollections implements delivery.Delivery
func (_d telemetryMiddleware) ListCollections(ctx context.Context, spaceId string, envId string) (collections []*collections.Collection, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.ListCollections")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId,
				"envId":   envId}, map[string]interface{}{
				"collections": collections,
				"err":         err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.ListCollections(ctx, spaceId, envId)
}

// ListEnvironments implements delivery.Delivery
func (_d telemetryMiddleware) ListEnvironments(ctx context.Context, spaceId string) (envs []*environments.Environment, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.ListEnvironments")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId}, map[string]interface{}{
				"envs": envs,
				"err":  err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.ListEnvironments(ctx, spaceId)
}

// ListLocales implements delivery.Delivery
func (_d telemetryMiddleware) ListLocales(ctx context.Context, spaceId string) (locales []*locales.Locale, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Delivery.ListLocales")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId}, map[string]interface{}{
				"locales": locales,
				"err":     err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Delivery.ListLocales(ctx, spaceId)
}
