package client

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/delivery"
	"git.perx.ru/perxis/perxis-go/pkg/environments"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/locales"
)

type envsAdapter struct {
	environments.Environments
	dv delivery.Delivery
}

func (a envsAdapter) Get(ctx context.Context, spaceId, envId string) (env *environments.Environment, err error) {
	return a.dv.GetEnvironment(ctx, spaceId, envId)
}

func (a envsAdapter) List(ctx context.Context, spaceId string) (envs []*environments.Environment, err error) {
	return a.dv.ListEnvironments(ctx, spaceId)
}

type localesAdapter struct {
	locales.Locales
	dv delivery.Delivery
}

func (a localesAdapter) List(ctx context.Context, spaceId string) (locales []*locales.Locale, err error) {
	return a.dv.ListLocales(ctx, spaceId)
}

type collectionsAdapter struct {
	collections.Collections
	dv delivery.Delivery
}

func (a collectionsAdapter) Get(ctx context.Context, spaceId, envId, collectionId string, opts ...*collections.GetOptions) (collection *collections.Collection, err error) {
	return a.dv.GetCollection(ctx, spaceId, envId, collectionId)
}

func (a collectionsAdapter) List(ctx context.Context, spaceId, envId string, filter *collections.Filter) (collections []*collections.Collection, err error) {
	return a.dv.ListCollections(ctx, spaceId, envId)
}

type itemsAdapter struct {
	items.Items
	dv delivery.Delivery
}

func (a itemsAdapter) GetPublished(ctx context.Context, spaceId, envId, collectionId, itemId string, options ...*items.GetPublishedOptions) (item *items.Item, err error) {
	return a.dv.GetItem(ctx, spaceId, envId, collectionId, itemId, options...)
}

func (a itemsAdapter) FindPublished(ctx context.Context, spaceId, envId, collectionId string, filter *items.Filter, options ...*items.FindPublishedOptions) (items []*items.Item, total int, err error) {
	return a.dv.FindItems(ctx, spaceId, envId, collectionId, filter, options...)
}

func (a itemsAdapter) AggregatePublished(ctx context.Context, spaceId, envId, collectionId string, filter *items.Filter, options ...*items.AggregatePublishedOptions) (result map[string]interface{}, err error) {
	return a.dv.Aggregate(ctx, spaceId, envId, collectionId, filter, options...)
}
