package data

import (
	"testing"
)

func TestTranslit(t *testing.T) {
	type args struct {
		s         string
		lowercase bool
	}
	tests := []struct {
		name string
		args args
		want string
	}{
		{
			name: "test translit cyrillic",
			args: args{"Ёжик 2019", true},
			want: "yozhik-2019",
		},
		{
			name: "test translit cyrillic",
			args: args{"Ёжик", false},
			want: "Yozhik",
		},
		{
			name: "test translit english",
			args: args{"Hello world,sample", true},
			want: "hello-world-sample",
		},
		{
			name: "test translit english",
			args: args{"Специальные...символы", true},
			want: "specialnye---simvoly",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := StringTransform(tt.args.s, tt.args.lowercase); got != tt.want {
				t.Errorf("Translit() = %v, want %v", got, tt.want)
			}
		})
	}
}
