package data

import (
	"bytes"
	"strings"
	"unicode"
)

var mapRuEn = map[rune]string{
	'а': "a", 'б': "b", 'в': "v", 'г': "g", 'д': "d", 'е': "e", 'ё': "yo", 'ж': "zh", 'з': "z", 'и': "i", 'й': "j",
	'к': "k", 'л': "l", 'м': "m", 'н': "n", 'о': "o", 'п': "p", 'р': "r", 'с': "s", 'т': "t", 'у': "u", 'ф': "f",
	'х': "h", 'ц': "c", 'ч': "ch", 'ш': "sh", 'щ': "shh", 'ъ': "", 'ы': "y", 'ь': "", 'э': "e", 'я': "ya",
}

func mapSpecial(r rune) rune {
	if r <= unicode.MaxASCII && (unicode.IsLetter(r) || unicode.IsNumber(r) || r == ':' || r == '/') {
		return r
	}
	return '-'
}

func StringTransform(s string, lowercase bool) string {
	s = TableEncode(s, mapRuEn)
	s = strings.Map(mapSpecial, s)
	if lowercase {
		s = strings.ToLower(s)
	}
	return s
}

func TableEncode(s string, tlm map[rune]string) string {
	in := bytes.NewBufferString(s)
	out := bytes.NewBuffer(nil)

	for {
		r, _, err := in.ReadRune()
		if err != nil {
			break // EOF
		}

		tr, ok := tlm[unicode.ToLower(r)]
		if !ok {
			out.WriteRune(r)
			continue
		}

		if unicode.IsUpper(r) {
			tr = strings.Title(tr)
		}

		out.WriteString(tr)
	}
	return out.String()
}
