package data

import (
	"regexp"
	"strings"
	"unicode"
)

var (
	replacer = strings.NewReplacer("?", ".", "*", ".*")
)

func IsRegExp(s string) bool {
	var prev rune
	if len(s) < 2 {
		return false
	}

	if s[0] == '^' || s[len(s)-1] == '$' {
		return true
	}

	for _, r := range s {
		switch r {
		case '*', '+':
			if prev == '.' {
				return true
			}
		}
		prev = r
	}
	return false
}

func CamelCase(name string) string {
	newName := []rune{}
	for i, c := range name {
		if i == 0 {
			newName = append(newName, unicode.ToLower(c))
		} else {
			newName = append(newName, c)
		}
	}
	return string(newName)
}

func GlobMatch(s string, matches ...string) bool {

	for _, match := range matches {
		if match == "" {
			return false
		}

		if s == match || match == "*" {
			return true
		}

		ok, err := regexp.MatchString(GlobToRegexp(match), s)
		if err != nil {
			return false
		}

		if ok {
			return true
		}
	}

	return false
}

func GlobToRegexp(s string) string {
	s = strings.TrimSpace(s)

	if s == "*" {
		return s
	}
	// если вначале не звездочка, то ищем с начала (важно для применения индексов mongo)
	if s[0] != '*' {
		s = "^" + s
	} else {
		s = s[1:]
	}
	// убираем последую звездочку, работает быстрее в mongo
	if s[len(s)-1] == '*' {
		s = s[:len(s)-1]
	} else {
		s = s + "$"
	}

	return replacer.Replace(s)
}
