// Code generated by microgen 0.9.1. DO NOT EDIT.

// It is better for you if you do not change functions names!
// This file will never be overwritten.
package transportgrpc

import (
	"fmt"

	service "git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/permission"
	schema "git.perx.ru/perxis/perxis-go/pkg/schema"
	pb "git.perx.ru/perxis/perxis-go/proto/collections"
	commonpb "git.perx.ru/perxis/perxis-go/proto/common"
	jsoniter "github.com/json-iterator/go"
	"google.golang.org/protobuf/types/known/timestamppb"
)

func PtrSchemaSchemaToProto(schema *schema.Schema) (string, error) {
	if schema == nil {
		return "", nil
	}
	res, err := jsoniter.MarshalToString(schema)
	if err != nil {
		return "", err
	}
	return res, nil
}

func ProtoToPtrSchemaSchema(protoSchema string) (*schema.Schema, error) {
	if protoSchema == "" {
		return nil, nil
	}
	sch := schema.New()
	err := sch.UnmarshalJSON([]byte(protoSchema))
	if err != nil {
		return nil, fmt.Errorf("failed to decode schema. err: %s", err.Error())
	}
	return sch, nil
}

func PtrCollectionToProto(coll *service.Collection) (*pb.Collection, error) {
	if coll == nil {
		return nil, nil
	}

	var access *pb.Access

	if coll.Access != nil {
		actions := make([]commonpb.Action, len(coll.Access.Actions))
		for i, a := range coll.Access.Actions {
			actions[i] = commonpb.Action(a)
		}
		access = &pb.Access{
			Actions:         actions,
			HiddenFields:    coll.Access.HiddenFields,
			ReadonlyFields:  coll.Access.ReadonlyFields,
			WriteonlyFields: coll.Access.WriteonlyFields,
		}
	}
	protoCollection := &pb.Collection{
		Id:      coll.ID,
		SpaceId: coll.SpaceID,
		EnvId:   coll.EnvID,
		Name:    coll.Name,
		Single:  coll.Single,
		System:  coll.System,
		NoData:  coll.NoData,
		Access:  access,
		Hidden:  coll.Hidden,
		Tags:    coll.Tags,
	}

	if coll.StateInfo != nil {
		protoCollection.StateInfo = &pb.Collection_StateInfo{
			State:     pb.Collection_State(coll.StateInfo.State),
			Info:      coll.StateInfo.Info,
			StartedAt: timestamppb.New(coll.StateInfo.StartedAt),
		}
	}

	sch, err := PtrSchemaSchemaToProto(coll.Schema)
	if err != nil {
		return nil, err
	}
	protoCollection.Schema = sch

	if coll.View != nil {
		protoCollection.View = &pb.Collection_View{
			SpaceId:      coll.View.SpaceID,
			EnvId:        coll.View.EnvID,
			CollectionId: coll.View.CollectionID,
			Filter:       coll.View.Filter,
		}
	}

	return protoCollection, nil
}

func ProtoToPtrCollection(protoCollection *pb.Collection) (*service.Collection, error) {
	if protoCollection == nil {
		return nil, nil
	}

	var access *service.Access

	if protoCollection.Access != nil {
		actions := make([]permission.Action, len(protoCollection.Access.Actions))
		for i, a := range protoCollection.Access.Actions {
			actions[i] = permission.Action(a)
		}
		access = &service.Access{
			Actions:         actions,
			HiddenFields:    protoCollection.Access.HiddenFields,
			ReadonlyFields:  protoCollection.Access.ReadonlyFields,
			WriteonlyFields: protoCollection.Access.WriteonlyFields,
		}
	}
	collection := &service.Collection{
		ID:      protoCollection.Id,
		SpaceID: protoCollection.SpaceId,
		EnvID:   protoCollection.EnvId,
		Name:    protoCollection.Name,
		Single:  protoCollection.Single,
		System:  protoCollection.System,
		NoData:  protoCollection.NoData,
		Access:  access,
		Hidden:  protoCollection.Hidden,
		Tags:    protoCollection.Tags,
	}

	if protoCollection.StateInfo != nil {
		collection.StateInfo = &service.StateInfo{
			State:     service.State(protoCollection.StateInfo.State),
			Info:      protoCollection.StateInfo.Info,
			StartedAt: protoCollection.StateInfo.StartedAt.AsTime(),
		}
	}

	schm, err := ProtoToPtrSchemaSchema(protoCollection.Schema)
	if err != nil {
		return nil, err
	}
	collection.Schema = schm

	if protoCollection.View != nil {
		collection.View = &service.View{
			SpaceID:      protoCollection.View.SpaceId,
			EnvID:        protoCollection.View.EnvId,
			CollectionID: protoCollection.View.CollectionId,
			Filter:       protoCollection.View.Filter,
		}
	}

	return collection, nil
}

func ListPtrCollectionToProto(collections []*service.Collection) ([]*pb.Collection, error) {
	protoCollections := make([]*pb.Collection, 0, len(collections))
	for _, collection := range collections {
		protoCollection, err := PtrCollectionToProto(collection)
		if err != nil {
			return nil, err
		}
		protoCollections = append(protoCollections, protoCollection)
	}
	return protoCollections, nil
}

func ProtoToListPtrCollection(protoCollections []*pb.Collection) ([]*service.Collection, error) {
	collections := make([]*service.Collection, 0, len(protoCollections))
	for _, protoCollection := range protoCollections {
		collection, err := ProtoToPtrCollection(protoCollection)
		if err != nil {
			return nil, err
		}
		collections = append(collections, collection)
	}
	return collections, nil
}

func ProtoToPtrBool(protoSingle *bool) (*bool, error) {
	panic("function not provided") // TODO: provide converter
}

func PtrBoolToProto(single *bool) (*bool, error) {
	panic("function not provided") // TODO: provide converter
}

func PtrFilterToProto(filter *service.Filter) (*pb.ListRequest_Filter, error) {
	if filter == nil {
		return nil, nil
	}
	return &pb.ListRequest_Filter{
		ExcludeSystem: filter.ExcludeSystem,
		IncludeNoData: filter.IncludeNoData,
		IncludeHidden: filter.IncludeHidden,
		Name:          filter.Name,
		Id:            filter.ID,
	}, nil
}

func ProtoToPtrFilter(protoFilter *pb.ListRequest_Filter) (*service.Filter, error) {
	if protoFilter == nil {
		return nil, nil
	}
	return &service.Filter{
		IncludeNoData: protoFilter.IncludeNoData,
		IncludeHidden: protoFilter.IncludeHidden,
		ExcludeSystem: protoFilter.ExcludeSystem,
		Name:          protoFilter.Name,
		ID:            protoFilter.Id,
	}, nil
}

func GetOptionsToProto(options []*service.GetOptions) *pb.GetOptions {
	opts := service.MergeGetOptions(options...)
	return &pb.GetOptions{DisableSchemaIncludes: opts.DisableSchemaIncludes}
}

func ProtoToGetOptions(protoOptions *pb.GetOptions) []*service.GetOptions {
	if protoOptions == nil {
		return nil
	}
	opts := &service.GetOptions{
		DisableSchemaIncludes: protoOptions.DisableSchemaIncludes,
	}
	return []*service.GetOptions{opts}
}
