package collections

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/schema"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/collections
// @grpc-addr content.collections.Collections
type Collections interface {
	Create(ctx context.Context, collection *Collection) (created *Collection, err error)
	Get(ctx context.Context, spaceId, envId, collectionId string, options ...*GetOptions) (collection *Collection, err error)
	List(ctx context.Context, spaceId, envId string, filter *Filter) (collections []*Collection, err error)
	Update(ctx context.Context, coll *Collection) (err error)
	SetSchema(ctx context.Context, spaceId, envId, collectionId string, schema *schema.Schema) (err error)

	// @microgen -
	SetState(ctx context.Context, spaceId, envId, collectionId string, state *StateInfo) (err error)
	Delete(ctx context.Context, spaceId, envId, collectionId string) (err error)
}

type Filter struct {
	IncludeNoData bool     `json:"include_no_data,omitempty"`
	IncludeHidden bool     `json:"include_hidden,omitempty"`
	ExcludeSystem bool     `json:"exclude_system,omitempty"`
	Name          []string `json:"name,omitempty"`
	ID            []string `json:"id,omitempty"`
}
