package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/access_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/collaborators -i Collaborators -t ../../../assets/templates/middleware/access_log -o logging_middleware.go -l ""

import (
	"context"
	"fmt"
	"time"

	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/collaborators"
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

// loggingMiddleware implements collaborators.Collaborators that is instrumented with logging
type loggingMiddleware struct {
	logger *zap.Logger
	next   collaborators.Collaborators
}

// LoggingMiddleware instruments an implementation of the collaborators.Collaborators with simple logging
func LoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next collaborators.Collaborators) collaborators.Collaborators {
		return &loggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *loggingMiddleware) Get(ctx context.Context, spaceId string, subject string) (role string, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":     ctx,
		"spaceId": spaceId,
		"subject": subject} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Get.Request", fields...)

	role, err = m.next.Get(ctx, spaceId, subject)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"role": role,
		"err":  err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Get.Response", fields...)

	return role, err
}

func (m *loggingMiddleware) ListCollaborators(ctx context.Context, spaceId string) (collaborators []*collaborators.Collaborator, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":     ctx,
		"spaceId": spaceId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListCollaborators.Request", fields...)

	collaborators, err = m.next.ListCollaborators(ctx, spaceId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"collaborators": collaborators,
		"err":           err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListCollaborators.Response", fields...)

	return collaborators, err
}

func (m *loggingMiddleware) ListSpaces(ctx context.Context, subject string) (spaces []*collaborators.Collaborator, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":     ctx,
		"subject": subject} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListSpaces.Request", fields...)

	spaces, err = m.next.ListSpaces(ctx, subject)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"spaces": spaces,
		"err":    err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("ListSpaces.Response", fields...)

	return spaces, err
}

func (m *loggingMiddleware) Remove(ctx context.Context, spaceId string, subject string) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":     ctx,
		"spaceId": spaceId,
		"subject": subject} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Remove.Request", fields...)

	err = m.next.Remove(ctx, spaceId, subject)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Remove.Response", fields...)

	return err
}

func (m *loggingMiddleware) Set(ctx context.Context, spaceId string, subject string, role string) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":     ctx,
		"spaceId": spaceId,
		"subject": subject,
		"role":    role} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Set.Request", fields...)

	err = m.next.Set(ctx, spaceId, subject, role)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Set.Response", fields...)

	return err
}
