package cli

import (
	"os"
	"os/signal"
	"syscall"

	"go.uber.org/zap"
)

func WaitForQuit(logger *zap.Logger, finailizer func()) {
	donec := make(chan struct{})
	sigc := make(chan os.Signal, 1)
	signal.Notify(sigc, syscall.SIGTERM, os.Interrupt)
	var signalsReceived uint
	go func() {
		for {
			select {
			case s := <-sigc:
				logger.Info("Signal received. Exiting", zap.String("Signal", s.String()))
				signalsReceived++

				if signalsReceived < 2 {
					// After first Ctrl+C start quitting the worker gracefully
					go func() {
						finailizer()
						close(donec)
					}()
				} else {
					// Abort the program when user hits Ctrl+C second time in a row
					logger.Info("Force exit")
					close(donec)
				}
			}
		}
	}()

	<-donec
	logger.Info("Quit")
}
