package auth

import (
	"context"
	"fmt"

	"git.perx.ru/perxis/perxis-go/pkg/members"
	"git.perx.ru/perxis/perxis-go/pkg/permission"
	"git.perx.ru/perxis/perxis-go/pkg/roles"
)

type SystemPrincipal struct{}

const (
	SystemID = "system"
)

func (p SystemPrincipal) GetID(ctx context.Context) string                            { return SystemID }
func (SystemPrincipal) IsValid(ctx context.Context) bool                              { return true }
func (SystemPrincipal) IsSystem(ctx context.Context) bool                             { return true }
func (SystemPrincipal) IsManagementAllowed(ctx context.Context, spaceID string) error { return nil }

func (p SystemPrincipal) Organization(_ string) OrganizationAccessor { return p }

func (p SystemPrincipal) Space(_ string) SpaceAccessor                  { return p }
func (SystemPrincipal) HasSpaceAccess(_ context.Context, _ string) bool { return true }
func (SystemPrincipal) HasAccess(ctx context.Context, spaceID, orgID string) error {
	return nil
}
func (SystemPrincipal) HasEnvironmentAccess(_ context.Context, _, _ string) bool { return true }
func (SystemPrincipal) Member(_ context.Context) members.Role                    { return members.NotMember }
func (SystemPrincipal) Role(_ context.Context, _ string) *roles.Role             { return nil }
func (SystemPrincipal) Rules(_ context.Context, _, _ string) permission.Ruleset {
	return &permission.PrivilegedRuleset{}
}

func (SystemPrincipal) Format(f fmt.State, verb rune) {
	f.Write([]byte("SystemPrincipal{}"))
}
